implementation module timerevent


//	Clean Object I/O library, version 1.1


import StdBool, StdInt
import iostate, devicefunctions, timeraccess


/*	The timerEvent function determines whether the given SchedulerEvent can be applied
	to a timer of this process. These are the following cases:
	*	ScheduleTimerEvent: the timer event belongs to this process and device
	*	ScheduleMsgEvent:   the message event belongs to this process and device
*/
timerEvent :: !(SchedulerEvent i o) !(IOSt .l .p) -> (!Bool,!Maybe (DeviceEvent i o),!SchedulerEvent i o,!IOSt .l .p)
timerEvent schedulerEvent=:(ScheduleTimerEvent te=:{teLoc}) ioState
	# (ioid,ioState)	= IOStGetIOId ioState
	| teLoc.tlIOId<>ioid || teLoc.tlDevice<>TimerDevice
	= (False,Nothing,schedulerEvent,ioState)
	# (timer,ioState)	= IOStGetDevice TimerDevice ioState
	# timers			= TimerSystemStateGetTimerHandles timer
	  (found,timers)	= lookForTimer teLoc.tlParentId timers
	# ioState			= IOStSetDevice (TimerSystemState timers) ioState
	| found
	= (True,Just (TimerEvent te),schedulerEvent,ioState)
	= (False,Nothing,schedulerEvent,ioState)
where
	lookForTimer :: !Id !(TimerHandles .ps) -> (!Bool,!TimerHandles .ps)
	lookForTimer parent timers=:{tTimers=tHs}
		# (found,tHs)	= UContains (identifyTimerStateHandle parent) tHs
		= (found,{timers & tTimers=tHs})
timerEvent schedulerEvent=:(ScheduleMsgEvent msgEvent) ioState
	# (ioid,ioState)	= IOStGetIOId ioState
	  recloc			= case msgEvent of
						  	(QASyncMessage {qasmRecLoc}) -> qasmRecLoc
						  	(ASyncMessage  { asmRecLoc}) -> asmRecLoc
						  	(SyncMessage   {  smRecLoc}) -> smRecLoc
	| ioid==recloc.rlIOId && TimerDevice==recloc.rlDevice
	= (True,Just (ReceiverEvent msgEvent),schedulerEvent,ioState)
	= (False,Nothing,schedulerEvent,ioState)
timerEvent schedulerEvent ioState
	= (False,Nothing,schedulerEvent,ioState)
